TYPO3 CMS
=========

[![Build Status](https://travis-ci.org/TYPO3/TYPO3.CMS.svg?branch=master)](https://travis-ci.org/TYPO3/TYPO3.CMS)

TYPO3 is an open source PHP based web content management system released
under the GNU GPL. TYPO3 is copyright (c) 1999-2017 by Kasper Skaarhoj.

This document provides a basic introduction to TYPO3.

Getting Started
---------------

TYPO3 requires a webserver with PHP and a database (MySQL recommended).
Accessing the backend through a supported browser.

Please see the INSTALL.md in this folder in order to set up a basic TYPO3
installation on your webserver.

What is TYPO3?
--------------

TYPO3 is a free and open source Content Management Framework. It is released
under the GNU General Public License. It can run on several web servers, such
as Apache or IIS, on top of many operating systems, among them Linux, Microsoft
Windows, FreeBSD or MacOS X.

TYPO3 was initially authored by Kasper Skårhøj and is now further developed
by a community of Active Contributors around a small TYPO3 CMS Team.

To get more info about the GPL license, visit
http://www.opensource.org/licenses/gpl-license.php

What is a Content Management Framework?
---------------------------------------

A Content Management Framework is more than just a content management system,
due to the separation of the streamlined core and optional plugins
(extensions). TYPO3 has an open API that allows you to extend the frontend (web
site) and/or backend (administration) functionalities.

The concept of extensions makes TYPO3 capable of being developed and used
in almost any way you can imagine, either by using any of the many extensions
which are available for download, or by writing your own.

TYPO3 System requirements
-----------------------------

TYPO3 is based upon PHP and uses a MySQL database. For more information
regarding these requirements see the [INSTALL.md](INSTALL.md) file in this folder.

Using the Database Abstraction Layer (DBAL) allows one to use TYPO3 with other
Database Management Systems, like PostgreSQL, Oracle and MSSQL.

TYPO3 resources
---------------

Here is an overview of the most important TYPO3 resources to help you get
started:

### Get more information

* https://typo3.org is the main project website. It provides up to
  date official news, information about events, access to downloading the
  products and extensions.

* https://wiki.typo3.org is a collaborative wiki, providing access to
  all kind of information around the TYPO3 ecosphere.

* https://docs.typo3.org/: TYPO3 is one of the most thoroughly
  documented OpenSource products around, with manuals covering basic
  tutorials, TypoScript, administration, development, core structure, etc.
  You should make the time to locate the various documents, and read those
  that apply to the work you want to do.

### Chat with us

The TYPO3 team is using a tool called Slack to openly communicate with each
other and with the public. Several teams use Slack as a way to communicate
internally and most channels are a welcome place for you to join and get
yourself involved.

* Register: https://forger.typo3.org/slack/
* Slack: https://typo3.slack.com/

### Exchange information, ask questions, get help

Slack is nice for short discussions, but when asking questions, most
answers are lost in the noise after a few minutes. To let everyone
profit from an answer, we recommend to ask questions on StackOverflow.
If you like, you can then post a link into the corresponding Slack
channel to raise attention. And please, do not forget to tag your
questions correctly with `TYPO3` (and possibly other tags like `Fluid`
or `Extbase`).

* [StackOverflow questions tagged "TYPO3"](https://stackoverflow.com/questions/tagged/typo3)

The community and all TYPO3 teams communicate through newsgroups, which can
also be accessed through mailing lists and forums. Any of these three ways
provide access to the same communication channels:

* Forum (Web): https://forum.typo3.org/
* Mailing Lists (Mail): https://typo3.org/support/mailing-lists/
* Newsgroups (NNTP): news://lists.typo3.org/

Contributing
------------

If you want to contribute to the TYPO3 CMS source code, take a look at our
Contributors Walkthrough and Review System:

* https://docs.typo3.org/typo3cms/ContributionWorkflowGuide/
* https://review.typo3.org/

The [repository at GitHub](https://github.com/TYPO3/TYPO3.CMS) is a
synchronized mirror of the primary TYPO3 CMS core git repository:

* https://git.typo3.org/Packages/TYPO3.CMS.git

If you want to file a bug report, maintain your own extension using our
infrastructure (Git, Issue Tracker, Wiki, etc), take a look at:

* https://forge.typo3.org

Final notes
-----------

TYPO3 is said to be one of the most sophisticated PHP / Internet related
applications available, and the more you play with it, the more you will agree.

Due to the advanced level of the code and functionality, a degree of study,
time and perseverance is required to fully understand it, and get the best from
it. You should keep trying, as we say it's definitely worth it. TYPO3 is the
Enterprise Content Management System "for all".

The GPL license allows for developments that are based upon TYPO3 to also be
freely available under the GPL. Please remember this, because TYPO3 is about
"Inspiring People To Share". If you are making money with TYPO3 you can donate
or become a member of the TYPO3 Association.

By becoming a supporting member, individuals and organisations mainly fund
core development of TYPO3. The decision about what the funds are used for, is
made by all members of the Association and the Expert Advisory Board (EAB).
The decisions will be made transparent to the community and especially the
supporting members. Your funds will also serve for other purposes as laid
out in the bylaws.

* Donate: https://typo3.org/donate
* Become a member of the TYPO3 Association:
  https://typo3.org/association/membership/levels/

Copyleft
--------

This document is a part of the TYPO3 project.

Written by Nigel Jackson, Ingmar Schlecht, Ernesto Baschny, Michael Stucki,
Oliver Hader, Ben van 't Ende and others.
