<?php
declare(strict_types=1);
namespace TYPO3\CMS\Form\Domain\Model\FormElements;

/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */

use TYPO3\CMS\Core\Utility\GeneralUtility;

/**
 * A generic file upload form element
 *
 * Scope: frontend
 */
class FileUpload extends AbstractFormElement
{

    /**
     * Initializes the Form Element by setting the data type to a Extbase File Reference
     * @internal
     */
    public function initializeFormElement()
    {
        $this->setDataType('TYPO3\CMS\Extbase\Domain\Model\FileReference');
        parent::initializeFormElement();
    }

    /**
     * @internal
     * @deprecated since TYPO3 v8, will be removed in TYPO3 v9
     */
    public function onBuildingFinished()
    {
        GeneralUtility::logDeprecatedFunction();
    }
}
