#!/usr/bin/env php
<?php
declare(strict_types = 1);
/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */

$dbJson = file_get_contents(dirname(__DIR__) . '/node_modules/mime-db/db.json');
$dbJson = json_decode($dbJson, true);

$mimeTypeMapping = [];
$mimeTypeString = '';
foreach ($dbJson as $mimeType => $mimeTypeInfo) {
    if (isset($mimeTypeInfo['extensions'])) {
        $mimeTypeMapping[$mimeType] = $mimeTypeInfo['extensions'];
    }
}

// @todo: add our own file extensions here

foreach ($mimeTypeMapping as $mimeType => $extensionInfo) {
    $mimeTypeString .= "        '" . $mimeType . "' => ['" . implode("', '", $extensionInfo) . "'],
";
}

$classTemplate = '<?php
declare(strict_types = 1);
namespace TYPO3\CMS\Core\Resource;

/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */

/**
 * This class contains a list of all available / known mimetypes and file extensions,
 * and is automatically generated by TYPO3 via Core/Build/Scripts/generateMimeTypes.php
 */
final class MimeTypeCollection
{
    private $map = [
' . rtrim($mimeTypeString, ',') .
'   ];

    /**
     * @return array<string, List<string>>
     */
    public function getMap(): array
    {
        return $this->map;
    }

    /**
     * @return List<string>
     */
    public function getMimeTypes(): array
    {
        return array_keys($this->map);
    }
}
';

file_put_contents(dirname(dirname(__DIR__)) . '/typo3/sysext/core/Classes/Resource/MimeTypeCollection.php', $classTemplate);
