<?php
/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */

return [
    'GFX' => [ // Configuration of the image processing features in TYPO3. 'IM' and 'GD' are short for ImageMagick and GD library respectively.
        'thumbnails' => 'Boolean: Enables the use of thumbnails in the backend interface.',
        'thumbnails_png' => 'Boolean. If false, thumbnails from non-image files will be converted to \'gif\', otherwise \'png\' (default).',
        'gif_compress' => 'Boolean: Enables the use of the <code>\\TYPO3\\CMS\\Core\\Utility\\GeneralUtility::gifCompress()</code> workaround function for compressing giffiles made with GD or IM, which probably use only RLE or no compression at all.',
        'imagefile_ext' => 'Commalist of file extensions perceived as images by TYPO3. List should be set to \'gif,png,jpeg,jpg\' if IM is not available. Lowercase and no spaces between!',
        'gdlib' => 'Boolean: Enables the use of GD.',
        'gdlib_png' => 'Boolean: Enables the use of GD, with PNG only. This means that all items normally generated as gif-files will be png-files instead!',
        'processor_enabled' => 'Boolean: Enables the use of Image- or GraphicsMagick.',
        'processor_path' => 'Path to the IM tools \'convert\', \'combine\', \'identify\'.',
        'processor_path_lzw' => 'Path to the IM tool \'convert\' with LZW enabled! See \'gif_compress\'. If your version 4.2.9 of ImageMagick is compiled with LZW you may leave this field blank AND disable the flag \'gif_compress\'! Tip: You can call LZW \'convert\' with a prefix like \'myver_convert\' by setting this path with it, eg. <code>/usr/bin/myver_</code> instead of just <code>/usr/bin/</code>.',
        'processor' => 'String: Set this either to "ImageMagick" or "GraphicsMagick". Setting this value will automatically configure some settings for use with the specified program version.',
        'processor_effects' => '<p>Integer (-1, 0, 1)</p><dl><dt>0</dt><dd>disabled</dd><dt>-1</dt><dd>Do not sharpen images by default</dd><dt>1</dt><dd>All; blur and sharpening is allowed in ImageMagick.</dd></dl>',
        'processor_allowUpscaling' => 'Boolean: If set, images can be scaled up if told so (in <code>\\TYPO3\\CMS\\Core\\Imaging\\GraphicalFunctions</code>)',
        'processor_allowFrameSelection' => 'Boolean: If set, the [x] frame selector is appended to input filenames in stdgraphic. This speeds up image processing for PDF files considerably. Disable if your image processor or environment can\'t cope with the frame selection.',
        'processor_allowTemporaryMasksAsPng' => 'Boolean: This should be set if your processor supports using PNGs as masks as this is usually faster.',
        'processor_stripColorProfileByDefault' => 'Boolean: If set, the processor_stripColorProfileCommand is used with all processor image operations by default. See tsRef for setting this parameter explicitly for IMAGE generation.',
        'processor_stripColorProfileCommand' => 'String: Specify the command to strip the profile information, which can reduce thumbnail size up to 60KB. Command can differ in IM/GM, IM also know the -strip command. See <a href="http://www.imagemagick.org/Usage/thumbnails/#profiles" target="_blank">imagemagick.org</a> for details',
        'processor_colorspace' => 'String: Specify the colorspace to use. Some ImageMagick versions (like 6.7.0 and above) use the sRGB colorspace, so all images are darker then the original. <br />Possible Values: CMY, CMYK, Gray, HCL, HSB, HSL, HWB, Lab, LCH, LMS, Log, Luv, OHTA, Rec601Luma, Rec601YCbCr, Rec709Luma, Rec709YCbCr, RGB, sRGB, Transparent, XYZ, YCbCr, YCC, YIQ, YCbCr, YUV',
        'jpg_quality' => 'Integer: Default JPEG generation quality',
        'png_truecolor' => 'Boolean: When creating png images, always use the full colorpalette, if disabled could reduce file sizes for scaled images, but the image quality will be let down.',
    ],
    'SYS' => [
        'fileCreateMask' => 'File mode mask for Unix file systems (when files are uploaded/created).',
        'folderCreateMask' => 'As above, but for folders.',
        'createGroup' => 'Group for newly created files and folders (Unix only). Group ownership can be changed on Unix file systems (see above). Set this if you want to change the group ownership of created files/folders to a specific group. This makes sense in all cases where the webserver is running with a different user/group as you do. Create a new group on your system and add you and the webserver user to the group. Now you can safely set the last bit in fileCreateMask/folderCreateMask to 0 (e.g. 770). Important: The user who is running your webserver needs to be a member of the group you specify here! Otherwise you might get some error messages.',
        'sitename' => 'Name of the base-site.',
        'encryptionKey' => 'This is a "salt" used for various kinds of encryption, CRC checksums and validations. You can enter any rubbish string here but try to keep it secret. You should notice that a change to this value might invalidate temporary information, URLs etc. At least, clear all cache if you change this so any such information can be rebuilt with the new key.',
        'cookieDomain' => 'Restricts the domain name for FE and BE session cookies. When setting the value to ".domain.com" (replace domain.com with your domain!), login sessions will be shared across subdomains. Alternatively, if you have more than one domain with sub-domains, you can set the value to a regular expression to match against the domain of the HTTP request. The result of the match is used as the domain for the cookie. eg. <code>/\\.(example1|example2)\\.com$/</code> or <code>/\\.(example1\\.com)|(example2\\.net)$/</code>. Separate domains for FE and BE can be set using <a href="#FE-cookieDomain">$TYPO3_CONF_VARS[\'FE\'][\'cookieDomain\']</a> and <a href="#BE-cookieDomain">$TYPO3_CONF_VARS[\'BE\'][\'cookieDomain\']</a> respectively.',
        'cookieSecure' => '<p>Integer (0, 1, 2): Indicates that the cookie should only be transmitted over a secure HTTPS connection from the client.</p><dl><dt>0</dt><dd>always send cookie</dd><dt>1 (force HTTPS)</dt><dd>the cookie will only be set if a secure (HTTPS) connection exists - use this in combination with lockSSL since otherwise the application will fail and throw an exception</dd><dt>2</dt><dd>the cookie will be set in each case, but uses the secure flag if a secure (HTTPS) connection exists.</dd></dl>',
        'doNotCheckReferer' => 'Boolean: If set, it\'s NOT checked numerous places that the referring host is the same as the current. This is an option you should set if you have problems with proxies not passing the HTTP_REFERER variable.',
        'recursiveDomainSearch' => 'Boolean: If set, the search for domain records will be done recursively by stripping parts of the hostname off until a matching domain record is found.',
        'trustedHostsPattern' => 'String: Regular expression pattern that matches all allowed hostnames (including their ports) of this TYPO3 installation, or the string "SERVER_NAME" (default). The default value <code>SERVER_NAME</code> checks if the HTTP Host header equals the SERVER_NAME and SERVER_PORT. This is secure in correctly configured hosting environments and does not need further configuration. If you cannot change your hosting environment, you can enter a regular expression here. Examples: <code>.*\\.domain\\.com</code> matches all hosts that end with <code>.domain.com</code> with all corresponding subdomains. <code>(.*\\.domain|.*\\.otherdomain)\\.com</code> matches all hostnames with subdomains from <code>.domain.com</code> and <code>.otherdomain.com</code>. Be aware that HTTP Host header may also contain a port. If your installation runs on a specific port, you need to explicitly allow this in your pattern, e.g. <code>www\\.domain\\.com:88</code> allows only <code>www.domain.com:88</code>, <strong>not</strong> <code>www.domain.com</code>. To disable this check completely (not recommended because it is <strong>insecure</strong>) you can use ".*" as pattern.',
        'devIPmask' => 'Defines a list of IP addresses which will allow development-output to display. The debug() function will use this as a filter. See the function <code>\\TYPO3\\CMS\\Core\\Utility\\GeneralUtility::cmpIP()</code> for details on syntax. Setting this to blank value will deny all. Setting to "*" will allow all.',
        'sqlDebug' => '<p>Integer (0, 1, 2). Allows displaying executed SQL queries in the browser (for debugging purposes and development)</p><dl><dt>0</dt><dd>no SQL shown (default)</dd><dt>1</dt><dd>show only failed queries</dd><dt>2</dt><dd>show all queries</dd></dl>',
        'enable_DLOG' => 'Boolean: Whether the developer log is enabled. See constant "TYPO3_DLOG"',
        'ddmmyy' => 'Format of Date-Month-Year - see PHP-function <a href="http://php.net/date" target="_blank">date()</a>',
        'hhmm' => 'Format of Hours-Minutes - see PHP-function <a href="http://php.net/date" target="_blank">date()</a>',
        'USdateFormat' => 'Boolean: If TRUE, dates entered in the TCEforms of the backend will be formatted mm-dd-yyyy',
        'loginCopyrightWarrantyProvider' => 'String: If you provide warranty for TYPO3 to your customers insert you (company) name here. It will appear in the login-dialog as the warranty provider. (You must also set URL below).',
        'loginCopyrightWarrantyURL' => 'String: Add the URL where you explain the extend of the warranty you provide. This URL is displayed in the login dialog as the place where people can learn more about the conditions of your warranty. Must be set (more than 10 chars) in addition with the \'loginCopyrightWarrantyProvider\' message.',
        'textfile_ext' => 'Text file extensions. Those that can be edited. Executable PHP files may not be editable in webspace if disallowed!',
        'mediafile_ext' => 'Commalist of file extensions perceived as media files by TYPO3. Lowercase and no spaces between!',
        'binPath' => 'String: List of absolute paths where external programs should be searched for. Eg. <code>/usr/local/webbin/,/home/xyz/bin/</code>. (ImageMagick path have to be configured separately)',
        'binSetup' => 'String (textarea): List of programs (separated by newline or comma). By default programs will be searched in default paths and the special paths defined by <code>binPath</code>. When PHP has openbasedir enabled the programs can not be found and have to be configured here. Example: <code>perl=/usr/bin/perl,unzip=/usr/local/bin/unzip</code>',
        'no_pconnect' => 'Boolean: If TRUE, "connect" is used to connect to the database. If FALSE, a persistent connection using "pconnect" will be established!',
        'dbClientCompress' => 'Boolean: if TRUE, data exchange between TYPO3 and database server will be compressed. This may improve performance if (1) database serever is on the different server and (2) network connection speed to database server is 100mbps or less. CPU usage will be higher if this option is used but database operations will be executed faster due to much less (up to 3 times) database network traffic. This option has no effect if MySQL server is localhost.',
        'setDBinit' => 'String (textarea): These commands are executed after the database connection was established. Hint: The previous default "SET NAMES utf8;" is not required any more and will be removed automatically if set!',
        'setMemoryLimit' => 'Integer: memory_limit in MB: If more than 16, TYPO3 will try to use ini_set() to set the memory limit of PHP to the value. This works only if the function ini_set() is not disabled by your sysadmin.',
        'phpTimeZone' => 'String: timezone to force for all date() and mktime() functions. A list of supported values can be found at <a href="http://php.net/manual/en/timezones.php" target="_blank">php.net</a>. If this is not set, a valid fallback will be searched for by PHP (php.ini\'s <a href="http://www.php.net/manual/en/datetime.configuration.php#ini.date.timezone" target="_blank">date.timezone</a> setting, server defaults, etc); and if no fallback is found, the value of "UTC" is used instead.',
        'systemLog' => '<p>String: semi-colon separated list. Defines one or more logging methods. Possible methods:</p><dl><dt>file,&lt;abs-path-to-file&gt;[,&lt;level&gt;]</dt><dd>logs to a file</dd><dt>mail,&lt;to&gt;[/&lt;from&gt;][,&lt;level&gt;]</dt><dd>sends the log entries via mail</dd><dt>syslog,&lt;facility&gt;,[,&lt;level&gt;]</dt><dd>uses the operating system\'s log. Facility may be one of LOCAL0..LOCAL7, USER (on Windows USER is the only valid type).</dd><dt>error_log[,,&lt;level&gt;]</dt><dd>uses the PHP error log</dd></dl><p>The &lt;level&gt; is the individual logging level (see <a href="#SYS-systemLogLevel">[SYS][systemLogLevel]</a>).</p>',
        'systemLogLevel' => '<p>Integer (0, 1, 2, 3, 4): Only messages with same or higher severity are logged.</p><ul><li>0: info</li><li>1: notice</li><li>2: warning</li><li>3: error</li><li>4: fatal error</li></ul>',
        'enableDeprecationLog' => 'If set, this configuration enables the logging of deprecated methods and functions. The following options are allowed: <dl><dt>String: &quot;file&quot; (or integer &quot;1&quot;)</dt><dd>The log file will be written to typo3conf/deprecation_[hash-value].log</dd><dt>String: &quot;devlog&quot;</dt><dd>The log will be written to the development log</dd><dt>String: &quot;console&quot;<dt><dd>The log will be displayed in the Backend\'s Debug Console.</dd></dl>Logging options &quot;file&quot;, &quot;devlog&quot; and &quot;console&quot; can be combined by comma-separating them.',
        'UTF8filesystem' => 'Boolean: If TRUE then TYPO3 uses utf-8 to store file names. This allows for accented Latin letters as well as any other non-latin characters like Cyrillic and Chinese.',
        'systemLocale' => 'String: locale used for certain system related functions, e.g. escaping shell commands. If problems with filenames containing special characters occur, the value of this option is probably wrong. See <a href="http://php.net/manual/en/function.setlocale.php" target="_blank">setlocale()</a>.',
        'reverseProxyIP' => 'String: list of IP addresses. If TYPO3 is behind one or more (intransparent) reverse proxies the IP addresses must be added here.',
        'reverseProxyHeaderMultiValue' => 'String: "none","first","last": defines which values of a proxy header (eg HTTP_X_FORWARDED_FOR) to use, if more than one is found. "none" discards the value, "first" and "last" use the first/last of the values in the list.',
        'reverseProxyPrefix' => 'String: optional prefix to be added to the internal URL (SCRIPT_NAME and REQUEST_URI).',
        'reverseProxySSL' => 'String: \'*\' or list of IP addresses of proxies that use SSL (https) for the connection to the client, but an unencrypted connection (http) to the server. If \'*\' all proxies defined in <a href="#SYS-reverseProxyIP">[SYS][reverseProxyIP]</a> use SSL.',
        'reverseProxyPrefixSSL' => 'String: prefix to be added to the internal URL (SCRIPT_NAME and REQUEST_URI) when accessing the server via an SSL proxy. This setting overrides <a href="#SYS-reverseProxyPrefix">[SYS][reverseProxyPrefix]</a>.',
        'defaultCategorizedTables' => 'List of comma separated tables that are categorizable by default.',
        'displayErrors' => '<p>Integer (-1, 0, 1). Configures whether PHP errors or Exceptions should be displayed.</p><dl><dt>0</dt><dd>Do not display any PHP error message. Sets PHP "display_errors" setting to 0. Overrides the value of [SYS][exceptionalErrors] and sets it to 0 (= no errors are turned into exceptions). The configured [SYS][productionExceptionHandler] is used as exception handler.</dd><dt>1</dt><dd>Display error messages with the registered [SYS][errorHandler]. Sets PHP "display_errors" setting to 1. The configured [SYS][debugExceptionHandler] is used as exception handler.</dd><dt>-1</dt><dd>TYPO3 CMS does not touch the PHP "display_errors" setting. If [SYS][devIPmask] matches the user\'s IP address, the configured [SYS][debugExceptionHandler] is used instead of the [SYS][productionExceptionHandler] to handle exceptions.</dd></dl>',
        'productionExceptionHandler' => 'String: Classname to handle exceptions that might happen in the TYPO3-code. Leave empty to disable exception handling. Default: "TYPO3\\\\CMS\\\\Core\\\\Error\\\\ProductionExceptionHandler". This exception handler displays a nice error message when something went wrong. The error message is logged to the configured logs. Note: The configured "productionExceptionHandler" is used if [SYS][displayErrors] is set to "0" or is set to "-1" and [SYS][devIPmask] doesn\'t match the user\'s IP.',
        'debugExceptionHandler' => 'String: Classname to handle exceptions that might happen in the TYPO3-code. Leave empty to disable exception handling. Default: "TYPO3\\\\CMS\\\\Core\\\\Error\\\\DebugExceptionHandler". This exception handler displays the complete stack trace of any encountered exception. The error message and the stack trace is logged to the configured logs. Note: The configured "debugExceptionHandler" is used if [SYS][displayErrors] is set to "1" or is set to "-1" or "2" and the [SYS][devIPmask] matches the user\'s IP.',
        'errorHandler' => 'String: Classname to handle PHP errors. E.g.: TYPO3\\CMS\\Core\\Error\\ErrorHandler. This class displays and logs all errors that are registered as [SYS][errorHandlerErrors]. Leave empty to disable error handling. Errors can be logged to syslog (see: [SYS][systemLog]), to the installed developer log and to the "syslog" table. If an error is registered in [SYS][exceptionalErrors] it will be turned into an exception to be handled by the configured exceptionHandler.',
        'errorHandlerErrors' => 'Integer: The E_* constant that will be handled by the [SYS][errorHandler]. Not all PHP error types can be handled! Default is 30466 = <code>E_ALL & ~(E_STRICT | E_NOTICE | E_COMPILE_WARNING | E_COMPILE_ERROR | E_CORE_WARNING | E_CORE_ERROR | E_PARSE | E_ERROR)</code> (see <a href="http://php.net/manual/en/errorfunc.constants.php" target="_blank">PHP documentation</a>).',
        'exceptionalErrors' => 'Integer: The E_* constant that will be converted into an exception by the default [SYS][errorHandler]. Default is 20480 = <code>E_ALL & ~(E_STRICT | E_NOTICE | E_COMPILE_WARNING | E_COMPILE_ERROR | E_CORE_WARNING | E_CORE_ERROR | E_PARSE | E_ERROR | E_DEPRECATED | E_WARNING | E_USER_ERROR | E_USER_NOTICE | E_USER_WARNING)</code> (see <a href="http://php.net/manual/en/errorfunc.constants.php" target="_blank">PHP documentation</a>).',
        'enable_errorDLOG' => 'Boolean: If set, errors are written to the developer log (requires an installed *devlog* extension).',
        'enable_exceptionDLOG' => 'Boolean: If set, exceptions are written to the developer log (requires an installed *devlog* extension).',
        'syslogErrorReporting' => 'Integer: Configures which PHP errors should be logged to the configured syslogs (see: [SYS][systemLog]). If set to "0" no PHP errors are logged to the syslog. Default is 30711 = <code>E_ALL & ~(E_STRICT | E_NOTICE)</code> (see <a href="http://php.net/manual/en/errorfunc.constants.php" target="_blank">PHP documentation</a>).',
        'belogErrorReporting' => 'Integer: Configures which PHP errors should be logged to the "syslog" table (extension: belog). If set to "0" no PHP errors are logged to the sys_log table. Default is 30711 = <code>E_ALL & ~(E_STRICT | E_NOTICE)</code> (see <a href="http://php.net/manual/en/errorfunc.constants.php" target="_blank">PHP documentation</a>).',
        'generateApacheHtaccess' => 'Boolean: TYPO3 can create <em>.htaccess</em> files which are used by Apache Webserver. They are useful for access protection or performance improvements. Currently <em>.htaccess</em> files in the following directories are created, if they do not exist: <ul><li>typo3temp/compressor/</li></ul>You want to disable this feature, if you are not running Apache or want to use own rulesets.',
        'isInitialInstallationInProgress' => 'Boolean: If TRUE, the installation is \'in progress\'. This value is handled within the install tool step installer internally.',
        'isInitialDatabaseImportDone' => 'Boolean: If TRUE, the database import is finished. This value is handled within the install tool step installer internally.',
    ],
    'EXT' => [ // Options related to the Extension Management
        'allowGlobalInstall' => 'Boolean: If set, global extensions in typo3/ext/ are allowed to be installed, updated and deleted etc.',
        'allowLocalInstall' => 'Boolean: If set, local extensions in typo3conf/ext/ are allowed to be installed, updated and deleted etc.',
        'allowSystemInstall' => 'Boolean: If set, you can install extensions in the sysext/ dir.',
        'excludeForPackaging' => 'String: List of directories and files which will not be packaged into extensions nor taken into account otherwise by the Extension Manager. Perl regular expression syntax!',
    ],
    'BE' => [ // Backend Configuration.
        'languageDebug' => 'Boolean: If set languageDebug will be enabled in LanguageService.',
        'fileadminDir' => 'Path to the fileadmin dir. This is relative to PATH_site, DefaultStorage will be created with that configuration, do not access manually but <code>\\TYPO3\\CMS\\Core\\Resource\\ResourceFactory::getDefaultStorage().</code>',
        'RTE_imageStorageDir' => 'Default storage directory for Rich Text Editor files.',
        'lockRootPath' => 'This path is used to evaluate if paths outside of PATH_site should be allowed. Ending slash required!',
        'userHomePath' => 'Combined folder identifier of the directory where TYPO3 backend-users have their home-dirs. A combined folder identifier looks like this: [storageUid]:[folderIdentifier]. Eg. <code>2:users/</code>. A home for backend user 2 would be: <code>2:users/2/</code>. Ending slash required!',
        'groupHomePath' => 'Combined folder identifier of the directory where TYPO3 backend-groups have their home-dirs. A combined folder identifier looks like this: [storageUid]:[folderIdentifier]. Eg. <code>2:groups/</code>. A home for backend group 1 would be: <code>2:groups/1/</code>. Ending slash required!',
        'userUploadDir' => 'Suffix to the user home dir which is what gets mounted in TYPO3. Eg. if the user dir is <code>../123_user/</code> and this value is <code>/upload</code> then <code>../123_user/upload</code> gets mounted.',
        'warning_email_addr' => 'Email address that will receive notification whenever an attempt to login to the Install Tool is made and that will also receive warnings whenever more than 3 failed backend login attempts (regardless of user) are detected within an hour.',
        'warning_mode' => 'Bit 1: If set, <code>warning_email_addr</code> will be notified every time a backend user logs in. Bit 2: If set, <code>warning_email_addr</code> will be notified every time an ADMIN backend user logs in.',
        'lockIP' => 'Integer (0-4). Session IP locking for backend users. See <a href="#FE-lockIP">[FE][lockIP]</a> for details. Default is 4 (which is locking the FULL IP address to session).',
        'sessionTimeout' => 'Integer: seconds. Session time out for backend users. The value must be at least 180 to avoid side effects. Default is 3600 seconds = 1 hour.',
        'IPmaskList' => 'String: Lets you define a list of IP-numbers (with *-wildcards) that are the ONLY ones allowed access to ANY backend activity. On error an error header is sent and the script exits. Works like IP masking for users configurable through TSconfig. See syntax for that (or look up syntax for the function <code>\\TYPO3\\CMS\\Core\\Utility\\GeneralUtility::cmpIP())</code>',
        'lockBeUserToDBmounts' => 'Boolean: If set, the backend user is allowed to work only within his page-mount. It\'s advisable to leave this on because it makes security easy to manage.',
        'lockSSL' => 'Boolean. If set, the backend can only be operated from an SSL-encrypted connection (https). A redirect to the SSL version of a URL will happen when a user tries to access non-https admin-urls',
        'lockSSLPort' => 'Integer: Use a non-standard HTTPS port for lockSSL. Set this value if you use lockSSL and the HTTPS port of your webserver is not 443.',
        'enabledBeUserIPLock' => 'Boolean: If set, the User/Group TSconfig option <code>option.lockToIP</code> is enabled.',
        'cookieDomain' => 'Same as <a href="#SYS-cookieDomain">$TYPO3_CONF_VARS[\'SYS\'][\'cookieDomain\']</a> but only for BE cookies. If empty, $TYPO3_CONF_VARS[\'SYS\'][\'cookieDomain\'] value will be used.',
        'cookieName' => 'String: Set the name for the cookie used for the back-end user session',
        'loginSecurityLevel' => 'String: Keywords that determines the security level of login to the backend. "normal" means the password from the login form is sent in clear-text, "rsa" uses RSA password encryption (only if the rsaauth extension is installed).',
        'showRefreshLoginPopup' => 'Boolean: If set, the Ajax relogin will show a real popup window for relogin after the count down. Some auth services need this as they add custom validation to the login form. If it\'s not set, the Ajax relogin will show an inline relogin window.',
        'adminOnly' => '<p>Integer (-1, 0, 1, 2)</p><dl><dt>-1</dt><dd>total shutdown for maintenance purposes</dd><dt>0</dt><dd>normal operation, everyone can login (default)</dd><dt>1</dt><dd>only admins can login (no CLI)</dd><dt>2</dt><dd>only admins and regular CLI users can login</dd></dl>',
        'disable_exec_function' => 'Boolean: Don\'t use exec() function (except for ImageMagick which is disabled by <a href="#GFX-im">[GFX][im]</a>=0). If set, all file operations are done by the default PHP-functions. This is necessary under Windows! On Unix the system commands by exec() can be used, unless this is disabled.',
        'compressionLevel' => 'Determines output compression of BE output. Makes output smaller but slows down the page generation depending on the compression level. Requires a) zlib in your PHP installation and b) special rewrite rules for .css.gzip and .js.gzip (please see <code>_.htacces</code> for an example). Range 1-9, where 1 is least compression and 9 is greatest compression. \'true\' as value will set the compression based on the PHP default settings (usually 5). Suggested and most optimal value is 5.',
        'installToolPassword' => 'String: This is the md5-hashed, salted password for the Install Tool. Set this to \'\' and access will be totally denied. You may consider to externally protect the typo3/sysext/install/ folder, eg. with a .htaccess file.',
        'checkStoredRecords' => 'Boolean: If set, values of the record are validated after saving in DataHandler. Disable only if using a database in strict mode.',
        'checkStoredRecordsLoose' => 'Boolean: If set, make a loose comparison (\'\' equals 0) when validating record values after saving in DataHandler.',
        'fileDenyPattern' => 'A perl-compatible regular expression (without delimiters!) that - if it matches a filename - will deny the file upload/rename or whatever in the webspace. For security reasons, files with multiple extensions have to be denied on an Apache environment with mod_alias, if the filename contains a valid php handler in an arbitrary position. Also, ".htaccess" files have to be denied. Matching is done case-insensitive. Default value is stored in constant FILE_DENY_PATTERN_DEFAULT',
        'interfaces' => 'This determines which interface options are available in the login prompt (All options: "backend,frontend")',
        'explicitADmode' => 'Sets the general allow/deny mode for selector box values. Value can be either "explicitAllow" or "explicitDeny", nothing else!',
        'flexformForceCDATA' => 'Boolean: If set, will add CDATA to Flexform XML. Some versions of libxml have a bug that causes HTML entities to be stripped from any XML content and this setting will avoid the bug by adding CDATA.',
        'explicitConfirmationOfTranslation' => 'If set, then the diff-data of localized records is not saved automatically when updated but requires that a translator clicks the special finish_translation/save/close button that becomes available.',
        'versionNumberInFilename' => '<p>Boolean: If TRUE, included CSS and JS files will have the timestamp embedded in the filename, ie. filename.1269312081.js. This will make browsers and proxies reload the files if they change (thus avoiding caching issues). IMPORTANT: this feature requires extra .htaccess rules to work (please refer to _.htaccess or the _.htaccess file from the dummy package)</p><p>If FALSE the filemtime will be appended as a query-string.</p>',
        'debug' => 'Boolean: If set, the loginrefresh is disabled and pageRenderer is set to debug mode. Use this to debug the backend only!',
    ],
    'FE' => [ // Configuration for the TypoScript frontend (FE). Nothing here relates to the administration backend!
        'addAllowedPaths' => 'Additional relative paths (comma-list) to allow TypoScript resources be in. Should be prepended with \'/\'. If not, then any path where the first part is like this path will match. That is: \'myfolder/ , myarchive\' will match eg. \'myfolder/\', \'myarchive/\', \'myarchive_one/\', \'myarchive_2/\' ... No check is done to see if this directory actually exists in the root of the site. Paths are matched by simply checking if these strings equals the first part of any TypoScript resource filepath. (See class template, function init() in <code>\\TYPO3\\CMS\\Core\\TypoScript\\Parser\\TypoScriptParser)</code>',
        'debug' => 'Boolean: If set, some debug HTML-comments may be output somewhere. Can also be set by TypoScript.',
        'noPHPscriptInclude' => 'Boolean: If set, PHP-scripts are not included by TypoScript configurations, unless they reside in the folders typo3/ext/, typo3/sysext/ or typo3conf/ext. This is a security option to ensure that users with template-access do not terrorize',
        'compressionLevel' => 'Integer: Determines output compression of FE output. Makes output smaller but slows down the page generation depending on the compression level. Requires zlib in your PHP installation. Range 1-9, where 1 is least compression and 9 is greatest compression. \'true\' as value will set the compression based on the PHP default settings (usually 5). Suggested and most optimal value is 5.',
        'pageNotFound_handling' => '<p>How TYPO3 should handle requests for non-existing/accessible pages.</p> <dl><dt>empty (default)</dt><dd>The next visible page upwards in the page tree is shown.</dd> <dt>\'true\' or \'1\'</dt><dd>An error message is shown.</dd><dt>String</dt><dd>Static HTML file to show (reads content and outputs with correct headers), e.g. \'notfound.html\' or \'http://www.example.org/errors/notfound.html\'.</dd> <dt>Prefix "REDIRECT:"</dt><dd> If prefixed with "REDIRECT:" it will redirect to the URL/script after the prefix.</dd><dt>Prefix "READFILE:"</dt><dd>If prefixed with "READFILE" then it will expect the remaining string to be a HTML file which will be read and outputted directly after having the marker "###CURRENT_URL###" substituted with REQUEST_URI and ###REASON### with reason text, for example: "READFILE:fileadmin/notfound.html".</dd> <dt>Prefix "USER_FUNCTION:"</dt><dd> If prefixed with "USER_FUNCTION:" a user function is called, e.g. "USER_FUNCTION:fileadmin/class.user_notfound.php:user_notFound->pageNotFound" where the file must contain a class "user_notFound" with a method "pageNotFound" inside with two parameters $param and $ref.</dd></dl>',
        'pageNotFound_handling_statheader' => 'If \'pageNotFound_handling\' is enabled, this string will always be sent as header before the actual handling. This applies to non-access-restriction related errors.',
        'pageNotFound_handling_accessdeniedheader' => 'If \'pageNotFound_handling\' is enabled, this string will always be sent as header before the actual handling.',
        'pageNotFoundOnCHashError' => 'Boolean: If TRUE, a page not found call is made when cHash evaluation error occurs, otherwise caching is disabled and page output is displayed.',
        'pageUnavailable_handling' => '<p>How TYPO3 should handle requests when pages are unavailable due to system problems.</p><dl><dt>empty (default)</dt><dd>An error message is shown.</dd><dt>String</dt><dd>HTML file or URL to show (reads content and outputs with correct headers), e.g. \'unavailable.html\' or \'http://www.example.org/errors/unavailable.html\'.</dd><dt>Prefix "REDIRECT:"</dt><dd>If prefixed "REDIRECT:" it will redirect to the URL/script after the prefix.</dd><dt>Prefix "READFILE:"</dt><dd>If prefixed with "READFILE:" then it will expect the remaining string to be a HTML file which will be read and outputted directly after having the marker "###CURRENT_URL###" substituted with REQUEST_URI and ###REASON### with reason text, for example: "READFILE:fileadmin/unavailable.html".</dd><dt>Prefix "USER_FUNCTION:"</dt><dd>If prefixed "USER_FUNCTION:" then it will call a user function, eg. "USER_FUNCTION:fileadmin/class.user_unavailable.php:user_unavailable->pageUnavailable" where the file must contain a class "user_unavailable" with a method "pageUnavailable" inside with two parameters $param and $ref. If the client matches <a href="#SYS-devIPmask">[SYS][devIPmask]</a>, this setting is ignored and the page is shown as normal.</dd></dl>',
        'pageUnavailable_handling_statheader' => 'If \'pageUnavailable_handling\' is enabled, this string will always be sent as header before the actual handling.',
        'pageUnavailable_force' => 'Boolean: If TRUE, pageUnavailable_handling is used for every frontend page. If the client matches <a href="#SYS-devIPmask">[SYS][devIPmask]</a>, the page is shown as normal. This is useful during temporary site maintenance.',
        'addRootLineFields' => 'Comma-list of fields from the \'pages\'-table. These fields are added to the select query for fields in the rootline.',
        'checkFeUserPid' => 'Boolean: If set, the pid of fe_user logins must be sent in the form as the field \'pid\' and then the user must be located in the pid. If you unset this, you should change the fe_users.username eval-flag \'uniqueInPid\' to \'unique\' in $TCA. This will do: <code>$TCA[\'fe_users\'][\'columns\'][\'username\'][\'config\'][\'eval\']= \'nospace,lower,required,unique\';</code>',
        'lockIP' => 'Integer (0-4). If >0, fe_users are locked to (a part of) their REMOTE_ADDR IP for their session. Enhances security but may throw off users that may change IP during their session (in which case you can lower it to 2 or 3). The integer indicates how many parts of the IP address to include in the check. Reducing to 1-3 means that only first, second or third part of the IP address is used. 4 is the FULL IP address and recommended. 0 (zero) disables checking of course.',
        'loginSecurityLevel' => 'See description for <a href="#BE-loginSecurityLevel">[BE][loginSecurityLevel]</a>. Default state for frontend is "normal". Alternative authentication services can implement higher levels if preferred. For example, "rsa" level uses RSA password encryption (only if the rsaauth extension is installed).',
        'lifetime' => 'Integer: positive. If >0 and the option permalogin is >=0, the cookie of FE users will have a lifetime of the number of seconds this value indicates. Otherwise it will be a session cookie (deleted when browser is shut down). Setting this value to 604800 will result in automatic login of FE users during a whole week, 86400 will keep the FE users logged in for a day.',
        'sessionDataLifetime' => 'Integer: positive. If >0, the session data of an anonymous session will timeout and be removed after the number of seconds given (86400 seconds represents 24 hours).',
        'maxSessionDataSize' => 'Integer: Setting (deprecated) the maximum size (bytes) of frontend session data stored in the table fe_session_data. Set to zero (0) means no limit, but this is not recommended since it also disables a check that session data is stored only if a confirmed cookie is set. <code>@deprecated since TYPO3 v8, will be removed in TYPO3 v9.</code>',
        'permalogin' => '<dl><dt>-1</dt><dd>Permanent login for FE users is disabled.</dd><dt>0</dt><dd>By default permalogin is disabled for FE users but can be enabled by a form control in the login form.</dd><dt>1</dt><dd>Permanent login is by default enabled but can be disabled by a form control in the login form.</dd><dt>2</dt><dd>Permanent login is forced to be enabled.</dd></dl>In any case, permanent login is only possible if <a href="#FE-lifetime">[FE][lifetime]</a> lifetime is > 0.',
        'cookieDomain' => 'Same as <a href="#SYS-cookieDomain">$TYPO3_CONF_VARS[\'SYS\'][\'cookieDomain\']</a> but only for FE cookies. If empty, $TYPO3_CONF_VARS[\'SYS\'][\'cookieDomain\'] value will be used.',
        'cookieName' => 'String: Set the name for the cookie used for the front-end user session',
        'defaultUserTSconfig' => 'String (textarea). Enter lines of default frontend user/group TSconfig.',
        'defaultTypoScript_constants' => 'String (textarea). Enter lines of default TypoScript, constants-field.',
        'defaultTypoScript_setup' => 'String (textarea). Enter lines of default TypoScript, setup-field.',
        'additionalAbsRefPrefixDirectories' => 'Enter additional directories to be prepended with absRefPrefix. Directories must be comma-separated. TYPO3 already prepends the following directories: typo3/, typo3temp/, typo3conf/ext/ and all local storages',
        'get_url_id_token' => 'This is the token, which is substituted in the output code in order to keep a GET-based session going. Normally the GET-session-id is 5 chars (\'&amp;ftu=\') + hash_length (norm. 10)',
        'content_doktypes' => 'List of pages.doktype values which can contain content (so shortcut pages and external url pages are excluded, but all pages below doktype 199 should be included. doktype=6 is not either (backend users only...).',
        'enable_mount_pids' => 'Boolean: If set to "1", the mount_pid feature allowing \'symlinks\' in the page tree (for frontend operation) is allowed.',
        'hidePagesIfNotTranslatedByDefault' => 'Boolean: If TRUE, pages that has no translation will be hidden by default. Basically this will inverse the effect of the page localization setting "Hide page if no translation for current language exists" to "Show page even if no translation exists"',
        'disableNoCacheParameter' => 'Boolean: If set, the no_cache request parameter will become ineffective. This is currently still an experimental feature and will require a website only with plugins that don\'t use this parameter. However, using "&amp;no_cache=1" should be avoided anyway because there are better ways to disable caching for a certain part of the website (see COA_INT/USER_INT documentation in TSref).',
        'cHashExcludedParameters' => 'String: The the given parameters will be ignored in the cHash calculation. Example: L,tx_search_pi1[query]',
        'cHashOnlyForParameters' => 'String: Only the given parameters will be evaluated in the cHash calculation. Example: tx_news_pi1[uid]',
        'cHashRequiredParameters' => 'Optional: Configure Parameters that require a cHash. If no cHash is given but one of the parameters are set, then TYPO3 triggers the configured cHash Error behaviour',
        'cHashExcludedParametersIfEmpty' => 'Optional: Configure Parameters that are only relevant for the chash if there\'s an associated value available. And asterisk "*" can be used to skip all empty parameters.',
        'workspacePreviewLogoutTemplate' => 'If set, points to an HTML file relative to the TYPO3_site root which will be read and outputted as template for this message. Example: <code>fileadmin/templates/template_workspace_preview_logout.html</code>. Inside you can put the marker %1$s to insert the URL to go back to. Use this in <code>&lt;a href="%1$s"&gt;Go back...&lt;/a&gt;</code> links.',
        'versionNumberInFilename' => 'String: embed,querystring,\'\'. Allows to automatically include a version number (timestamp of the file) to referred CSS and JS filenames on the rendered page. This will make browsers and proxies reload the files if they change (thus avoiding caching issues). Set to \'embed\' will have the timestamp embedded in the filename, ie. filename.1269312081.js. IMPORTANT: \'embed\' requires extra .htaccess rules to work (please refer to _.htaccess or the _.htaccess file from the dummy package)<p>Set to \'querystring\' (default setting) to append the version number as a query parameter (doesn\'t require mod_rewrite).</p>',
    ],
    'MAIL' => [ // Mail configurations to tune how \TYPO3\CMS\Core\Mail\ classes will send their mails.
        'transport' => '<p>String:</p><dl><dt>mail</dt><dd>Sends messages by delegating to PHP\'s internal mail() function. No further settings required. This is the most unreliable option. If you are serious about sending mails, consider using "smtp" or "sendmail".</dd><dt>smtp</dt><dd>Sends messages over the (standardized) Simple Message Transfer Protocol. It can deal with encryption and authentication. Most flexible option, requires a mail server and configurations in transport_smtp_* settings below. Works the same on Windows, Unix and MacOS.</dd><dt>sendmail</dt><dd>Sends messages by communicating with a locally installed MTA - such as sendmail. See setting transport_sendmail_command bellow.<dd><dt>mbox</dt><dd>This doesn\'t send any mail out, but instead will write every outgoing mail to a file adhering to the RFC 4155 mbox format, which is a simple text file where the mails are concatenated. Useful for debugging the mail sending process and on development machines which cannot send mails to the outside. Configure the file to write to in the \'transport_mbox_file\' setting below</dd><dt>&lt;classname&gt;</dt><dd>Custom class which implements Swift_Transport. The constructor receives all settings from the MAIL section to make it possible to add custom settings.</dd></dl>',
        'transport_smtp_server' => 'String: <em>only with transport=smtp</em>: &lt;server:port> of mailserver to connect to. &lt;port> defaults to "25".',
        'transport_smtp_encrypt' => 'String: <em>only with transport=smtp</em>: Connect to the server using the specified transport protocol. Requires openssl library. Usually available: <em>ssl, sslv2, sslv3, tls</em>. Check <a href="http://www.php.net/stream_get_transports" target="_blank">stream_get_transports()</a>.',
        'transport_smtp_username' => 'String: <em>only with transport=smtp</em>: If your SMTP server requires authentication, enter your username here.',
        'transport_smtp_password' => 'String: <em>only with transport=smtp</em>: If your SMTP server requires authentication, enter your password here.',
        'transport_sendmail_command' => 'String: <em>only with transport=sendmail</em>: The command to call to send a mail locally.',
        'transport_mbox_file' => 'String: <em>only with transport=mbox</em>: The file where to write the mails into. This file will be conforming the mbox format described in RFC 4155. It is a simple text file with a concatenation of all mails. Path must be absolute.',
        'defaultMailFromAddress' => 'String: This default email address is used when no other "from" address is set for a TYPO3-generated email. You can specify an email address only (ex. info@example.org).',
        'defaultMailFromName' => 'String: This default name is used when no other "from" name is set for a TYPO3-generated email.',
    ],
    'HTTP' => [ // HTTP configuration to tune how TYPO3 behaves on HTTP requests made by TYPO3. Have a look at http://docs.guzzlephp.org/en/latest/request-options.html for some background information on those settings.
        'cert' => 'Mixed: Set to a string to specify the path to a file containing a PEM formatted client side certificate. See http://docs.guzzlephp.org/en/latest/request-options.html#cert',
        'connect_timeout' => 'Integer: Default timeout for connection. Exception will be thrown if connecting to remote host takes more than this number of seconds.',
        'proxy' => 'Mixed: Default proxy server as "proxy.example.org", multiple proxies for different protocols can be added separately as array, as well as authentication and port, see http://docs.guzzlephp.org/en/latest/request-options.html#proxy',
        'ssl_key' => 'Mixed: Local certificate and an optional passphrase, see http://docs.guzzlephp.org/en/latest/request-options.html#ssl-key',
        'timeout' => 'Integer: Default timeout for whole request. Exception will be thrown if sending the request takes more than this number of seconds. Should be greater than connection timeout (see above) or "0" to not set a limit. Defaults to "0".',
        'verify' => 'Mixed: Describes the SSL certificate verification behavior of a request. http://docs.guzzlephp.org/en/latest/request-options.html#verify',
        'version' => 'String: Default HTTP protocol version. Use either "1.0" or "1.1".',
    ],
];
