/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
define(["require","exports","TYPO3/CMS/Core/lit-helper","TYPO3/CMS/Core/DocumentService","TYPO3/CMS/Backend/Notification","TYPO3/CMS/Backend/InfoWindow","TYPO3/CMS/Backend/BroadcastMessage","TYPO3/CMS/Backend/BroadcastService","TYPO3/CMS/Backend/Tooltip","nprogress","TYPO3/CMS/Backend/Icons","TYPO3/CMS/Core/Ajax/AjaxRequest","TYPO3/CMS/Core/Event/RegularEvent","TYPO3/CMS/Backend/Storage/ModuleStateStorage","TYPO3/CMS/Backend/Modal","TYPO3/CMS/Backend/Enum/Severity","TYPO3/CMS/Backend/Severity"],(function(e,t,o,n,i,r,l,a,d,s,c,u,m,f,p,g,h){"use strict";var w;!function(e){e.fileListFormSelector='form[name="fileListForm"]',e.commandSelector='input[name="cmd"]',e.searchFieldSelector='input[name="searchTerm"]',e.pointerFieldSelector='input[name="pointer"]'}(w||(w={}));class S{static submitClipboardFormWithCommand(e,t){const o=t.closest(w.fileListFormSelector);if(!o)return;const n=o.querySelector(w.commandSelector);if(n){if(n.value=e,"copyMarked"===e||"removeMarked"===e){const e=o.querySelector(w.pointerFieldSelector),t=S.parseQueryParameters(document.location).pointer;e&&t&&(e.value=t)}o.submit()}}static openInfoPopup(e,t){r.showItem(e,t)}static processTriggers(){const e=document.querySelector(".filelist-main");if(null===e)return;const t=encodeURIComponent(e.dataset.filelistCurrentIdentifier);f.ModuleStateStorage.update("file",t,!0,void 0),S.emitTreeUpdateRequest(e.dataset.filelistCurrentIdentifier)}static emitTreeUpdateRequest(e){const t=new l.BroadcastMessage("filelist","treeUpdateRequested",{type:"folder",identifier:e});a.post(t)}static parseQueryParameters(e){let t={};if(e&&Object.prototype.hasOwnProperty.call(e,"search")){let o=e.search.substr(1).split("&");for(let e=0;e<o.length;e++){const n=o[e].split("=");t[decodeURIComponent(n[0])]=decodeURIComponent(n[1])}}return t}static getReturnUrl(e){return""===e&&(e=top.list_frame.document.location.pathname+top.list_frame.document.location.search),encodeURIComponent(e)}constructor(){var e;this.downloadFilesAndFolders=e=>{const t=e.target,n=e.detail,r=n.configuration,l=[];n.checkboxes.forEach(e=>{const t=e.closest("tr");(null==t?void 0:t.dataset[r.folderIdentifier])?l.push(t.dataset[r.folderIdentifier]):(null==t?void 0:t.dataset[r.fileIdentifier])&&l.push(t.dataset[r.fileIdentifier])}),l.length?this.triggerDownload(l,r.downloadUrl,t):i.warning((0,o.lll)("file_download.invalidSelection"))},this.downloadFolder=e=>{const t=e.target,o=t.dataset.folderIdentifier;this.triggerDownload([o],t.dataset.folderDownload,t)},S.processTriggers(),n.ready().then(()=>{d.initialize(".table-fit a[title]"),new m("click",(e,t)=>{e.preventDefault(),S.openInfoPopup(t.dataset.filelistShowItemType,t.dataset.filelistShowItemIdentifier)}).delegateTo(document,"[data-filelist-show-item-identifier][data-filelist-show-item-type]"),new m("click",(e,t)=>{e.preventDefault(),S.openInfoPopup("_FILE",t.dataset.identifier)}).delegateTo(document,"a.filelist-file-info"),new m("click",(e,t)=>{e.preventDefault(),S.openInfoPopup("_FILE",t.dataset.identifier)}).delegateTo(document,"a.filelist-file-references"),new m("click",(e,t)=>{e.preventDefault();const o=t.getAttribute("href");let n=o?encodeURIComponent(o):encodeURIComponent(top.list_frame.document.location.pathname+top.list_frame.document.location.search);top.list_frame.location.href=o+"&redirect="+n}).delegateTo(document,"a.filelist-file-copy")}),new m("multiRecordSelection:action:edit",this.editFileMetadata).bindTo(document),new m("multiRecordSelection:action:delete",this.deleteMultiple).bindTo(document),new m("multiRecordSelection:action:download",this.downloadFilesAndFolders).bindTo(document),new m("click",this.downloadFolder).delegateTo(document,"button[data-folder-download]"),new m("multiRecordSelection:action:copyMarked",e=>{S.submitClipboardFormWithCommand("copyMarked",e.target)}).bindTo(document),new m("multiRecordSelection:action:removeMarked",e=>{S.submitClipboardFormWithCommand("removeMarked",e.target)}).bindTo(document);const t=""!==(null===(e=document.querySelector([w.fileListFormSelector,w.searchFieldSelector].join(" ")))||void 0===e?void 0:e.value);new m("search",e=>{var o;const n=e.target;""===n.value&&t&&(null===(o=n.closest(w.fileListFormSelector))||void 0===o||o.submit())}).delegateTo(document,w.searchFieldSelector)}deleteMultiple(e){e.preventDefault();const t=e.detail.configuration;p.advanced({title:t.title||"Delete",content:t.content||"Are you sure you want to delete those files and folders?",severity:g.SeverityEnum.warning,buttons:[{text:TYPO3.lang["button.close"]||"Close",active:!0,btnClass:"btn-default",trigger:()=>p.currentModal.trigger("modal-dismiss")},{text:t.ok||TYPO3.lang["button.ok"]||"OK",btnClass:"btn-"+h.getCssClass(g.SeverityEnum.warning),trigger:()=>{S.submitClipboardFormWithCommand("delete",e.target),p.currentModal.trigger("modal-dismiss")}}]})}editFileMetadata(e){e.preventDefault();const t=e.detail,o=t.configuration;if(!o||!o.idField||!o.table)return;const n=[];t.checkboxes.forEach(e=>{const t=e.closest("tr");null!==t&&t.dataset[o.idField]&&n.push(t.dataset[o.idField])}),n.length?window.location.href=top.TYPO3.settings.FormEngine.moduleUrl+"&edit["+o.table+"]["+n.join(",")+"]=edit&returnUrl="+S.getReturnUrl(o.returnUrl||""):i.warning("The selected elements can not be edited.")}triggerDownload(e,t,n){i.info((0,o.lll)("file_download.prepare"),"",2);const r=n.innerHTML;n.setAttribute("disabled","disabled"),c.getIcon("spinner-circle-dark",c.sizes.small).then(e=>{n.innerHTML=e}),s.configure({parent:"#typo3-filelist",showSpinner:!1}).start(),new u(t).post({items:e}).then(async e=>{let t=e.response.headers.get("Content-Disposition");if(!t){const t=await e.resolve();return void(!1===t.success&&t.status?i.warning((0,o.lll)("file_download."+t.status),(0,o.lll)("file_download."+t.status+".message"),10):i.error((0,o.lll)("file_download.error")))}t=t.substring(t.indexOf(" filename=")+10);const n=await e.raw().arrayBuffer(),r=new Blob([n],{type:e.raw().headers.get("Content-Type")}),l=URL.createObjectURL(r),a=document.createElement("a");a.href=l,a.download=t,document.body.appendChild(a),a.click(),URL.revokeObjectURL(l),document.body.removeChild(a),i.success((0,o.lll)("file_download.success"),"",2)}).catch(()=>{i.error((0,o.lll)("file_download.error"))}).finally(()=>{s.done(),n.removeAttribute("disabled"),n.innerHTML=r})}}return new S}));