/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
var __importDefault=this&&this.__importDefault||function(t){return t&&t.__esModule?t:{default:t}};define(["require","exports","jquery","lit","./Enum/Severity","TYPO3/CMS/Core/Ajax/AjaxRequest","TYPO3/CMS/Core/SecurityUtility","./Icons","./Severity","bootstrap"],(function(t,e,a,n,l,s,i,o,d){"use strict";var r,c,u,f;a=__importDefault(a),function(t){t.modal=".t3js-modal",t.content=".t3js-modal-content",t.title=".t3js-modal-title",t.close=".t3js-modal-close",t.body=".t3js-modal-body",t.footer=".t3js-modal-footer",t.iframe=".t3js-modal-iframe",t.iconPlaceholder=".t3js-modal-icon-placeholder"}(r||(r={})),function(t){t.small="small",t.default="default",t.medium="medium",t.large="large",t.full="full"}(c||(c={})),function(t){t.default="default",t.light="light",t.dark="dark"}(u||(u={})),function(t){t.default="default",t.ajax="ajax",t.iframe="iframe"}(f||(f={}));class m{static resolveEventNameTargetElement(t){const e=t.target,a=t.currentTarget;return e.dataset&&e.dataset.eventName?e:a.dataset&&a.dataset.eventName?a:null}static createModalResponseEventFromElement(t,e){return t&&t.dataset.eventName?new CustomEvent(t.dataset.eventName,{bubbles:!0,detail:{result:e,payload:t.dataset.eventPayload||null}}):null}constructor(t){this.sizes=c,this.styles=u,this.types=f,this.currentModal=null,this.instances=[],this.$template=(0,a.default)('\n    <div class="t3js-modal modal fade">\n        <div class="modal-dialog">\n            <div class="t3js-modal-content modal-content">\n                <div class="modal-header">\n                    <h4 class="t3js-modal-title modal-title"></h4>\n                    <button class="t3js-modal-close close">\n                        <span class="t3js-modal-icon-placeholder" data-icon="actions-close"></span>\n                        <span class="visually-hidden"></span>\n                    </button>\n                </div>\n                <div class="t3js-modal-body modal-body"></div>\n                <div class="t3js-modal-footer modal-footer"></div>\n            </div>\n        </div>\n    </div>'),this.defaultConfiguration={type:f.default,title:"Information",content:"No content provided, please check your <code>Modal</code> configuration.",severity:l.SeverityEnum.notice,buttons:[],style:u.default,size:c.default,additionalCssClasses:[],callback:a.default.noop(),ajaxCallback:a.default.noop(),ajaxTarget:null},this.securityUtility=t,(0,a.default)(document).on("modal-dismiss",this.dismiss),this.initializeMarkupTrigger(document)}dismiss(){this.currentModal&&this.currentModal.modal("hide")}confirm(t,e,n=l.SeverityEnum.warning,s=[],i){var o,r;return 0===s.length&&s.push({text:(0,a.default)(this).data("button-close-text")||(null===(o=null===TYPO3||void 0===TYPO3?void 0:TYPO3.lang)||void 0===o?void 0:o["button.cancel"])||"Cancel",active:!0,btnClass:"btn-default",name:"cancel"},{text:(0,a.default)(this).data("button-ok-text")||(null===(r=null===TYPO3||void 0===TYPO3?void 0:TYPO3.lang)||void 0===r?void 0:r["button.ok"])||"OK",btnClass:"btn-"+d.getCssClass(n),name:"ok"}),this.advanced({title:t,content:e,severity:n,buttons:s,additionalCssClasses:i,callback:t=>{t.on("button.clicked",t=>{"cancel"===t.target.getAttribute("name")?(0,a.default)(t.currentTarget).trigger("confirm.button.cancel"):"ok"===t.target.getAttribute("name")&&(0,a.default)(t.currentTarget).trigger("confirm.button.ok")})}})}loadUrl(t,e=l.SeverityEnum.info,a,n,s,i){return this.advanced({type:f.ajax,title:t,severity:e,buttons:a,ajaxCallback:s,ajaxTarget:i,content:n})}show(t,e,a=l.SeverityEnum.info,n,s){return this.advanced({type:f.default,title:t,content:e,severity:a,buttons:n,additionalCssClasses:s})}advanced(t){return t.type="string"==typeof t.type&&t.type in f?t.type:this.defaultConfiguration.type,t.title="string"==typeof t.title?t.title:this.defaultConfiguration.title,t.content="string"==typeof t.content||"object"==typeof t.content?t.content:this.defaultConfiguration.content,t.severity=void 0!==t.severity?t.severity:this.defaultConfiguration.severity,t.buttons=t.buttons||this.defaultConfiguration.buttons,t.size="string"==typeof t.size&&t.size in c?t.size:this.defaultConfiguration.size,t.style="string"==typeof t.style&&t.style in u?t.style:this.defaultConfiguration.style,t.additionalCssClasses=t.additionalCssClasses||this.defaultConfiguration.additionalCssClasses,t.callback="function"==typeof t.callback?t.callback:this.defaultConfiguration.callback,t.ajaxCallback="function"==typeof t.ajaxCallback?t.ajaxCallback:this.defaultConfiguration.ajaxCallback,t.ajaxTarget="string"==typeof t.ajaxTarget?t.ajaxTarget:this.defaultConfiguration.ajaxTarget,this.generate(t)}setButtons(t){const e=this.currentModal.find(r.footer);if(t.length>0){e.empty();for(let n=0;n<t.length;n++){const l=t[n],s=(0,a.default)("<button />",{class:"btn"});s.html("<span>"+this.securityUtility.encodeHtml(l.text,!1)+"</span>"),l.active&&s.addClass("t3js-active"),""!==l.btnClass&&s.addClass(l.btnClass),""!==l.name&&s.attr("name",l.name),l.action?s.on("click",()=>{e.find("button").not(s).addClass("disabled"),l.action.execute(s.get(0)).then(()=>{this.currentModal.modal("hide")})}):l.trigger&&s.on("click",l.trigger),l.dataAttributes&&Object.keys(l.dataAttributes).length>0&&Object.keys(l.dataAttributes).map(t=>{s.attr("data-"+t,l.dataAttributes[t])}),l.icon&&s.prepend('<span class="t3js-modal-icon-placeholder" data-icon="'+l.icon+'"></span>'),e.append(s)}e.show(),e.find("button").on("click",t=>{(0,a.default)(t.currentTarget).trigger("button.clicked")})}else e.hide();return this.currentModal}initializeMarkupTrigger(t){(0,a.default)(t).on("click",".t3js-modal-trigger",t=>{var e,n;t.preventDefault();const s=(0,a.default)(t.currentTarget),i=s.data("bs-content")||s.data("content")||"Are you sure?";let o=l.SeverityEnum.info;if(s.data("severity")in l.SeverityEnum){const t=s.data("severity");o=l.SeverityEnum[t]}let r=s.data("url")||null;if(null!==r){const t=r.includes("?")?"&":"?";r=r+t+a.default.param({data:s.data()})}this.advanced({type:null!==r?f.ajax:f.default,title:s.data("title")||"Alert",content:null!==r?r:i,severity:o,buttons:[{text:s.data("button-close-text")||(null===(e=null===TYPO3||void 0===TYPO3?void 0:TYPO3.lang)||void 0===e?void 0:e["button.close"])||"Close",active:!0,btnClass:"btn-default",trigger:()=>{this.currentModal.trigger("modal-dismiss");const e=m.resolveEventNameTargetElement(t),a=m.createModalResponseEventFromElement(e,!1);null!==a&&e.dispatchEvent(a)}},{text:s.data("button-ok-text")||(null===(n=null===TYPO3||void 0===TYPO3?void 0:TYPO3.lang)||void 0===n?void 0:n["button.ok"])||"OK",btnClass:"btn-"+d.getCssClass(o),trigger:()=>{var e;this.currentModal.trigger("modal-dismiss");const a=m.resolveEventNameTargetElement(t),n=m.createModalResponseEventFromElement(a,!0);null!==n&&a.dispatchEvent(n);let l=s.attr("data-uri")||s.data("href")||s.attr("href");l&&"#"!==l&&(t.target.ownerDocument.location.href=l),"submit"!==s.attr("type")||"BUTTON"!==s.prop("tagName")&&"INPUT"!==s.prop("tagName")||null===(e=s[0].form)||void 0===e||e.requestSubmit(s[0])}}]})})}generate(t){var e;const l=this.$template.clone();if(t.additionalCssClasses.length>0)for(let e of t.additionalCssClasses)l.addClass(e);if(l.addClass("modal-type-"+t.type),l.addClass("modal-severity-"+d.getCssClass(t.severity)),l.addClass("modal-style-"+t.style),l.addClass("modal-size-"+t.size),l.attr("tabindex","-1"),l.find(r.title).text(t.title),l.find(r.close+" .visually-hidden").text((null===(e=null===TYPO3||void 0===TYPO3?void 0:TYPO3.lang)||void 0===e?void 0:e["button.close"])||"Close"),l.find(r.close).on("click",()=>{l.modal("hide")}),"ajax"===t.type){const e=t.ajaxTarget?t.ajaxTarget:r.body,a=l.find(e);o.getIcon("spinner-circle",o.sizes.default,null,null,o.markupIdentifiers.inline).then(l=>{a.html('<div class="modal-loading">'+l+"</div>"),new s(t.content).get().finally(async()=>{this.currentModal.parent().length||this.currentModal.appendTo("body")}).then(async a=>{const n=await a.raw().text();this.currentModal.find(e).empty().append(n),t.ajaxCallback&&t.ajaxCallback(),this.currentModal.trigger("modal-loaded")}).catch(async a=>{const l=await a.raw().text(),s=this.currentModal.find(e).empty();l?s.append(l):(0,n.render)(n.html`<p><strong>Oops, received a ${a.response.status} response from </strong> <span class="text-break">${t.content}</span>.</p>`,s[0])})})}else"iframe"===t.type?(l.find(r.body).append((0,a.default)("<iframe />",{src:t.content,name:"modal_frame",class:"modal-iframe t3js-modal-iframe"})),l.find(r.iframe).on("load",()=>{l.find(r.title).text(l.find(r.iframe).get(0).contentDocument.title)})):("string"==typeof t.content&&(t.content=(0,a.default)("<p />").html(this.securityUtility.encodeHtml(t.content))),l.find(r.body).append(t.content));return l.on("shown.bs.modal",t=>{const e=(0,a.default)(t.currentTarget),n=e.prev(".modal-backdrop"),l=1e3+10*this.instances.length,s=l-10;e.css("z-index",l),n.css("z-index",s),e.find(r.footer).find(".t3js-active").first().focus(),e.find(r.iconPlaceholder).each((t,e)=>{o.getIcon((0,a.default)(e).data("icon"),o.sizes.small,null,null,o.markupIdentifiers.inline).then(t=>{this.currentModal.find(r.iconPlaceholder+"[data-icon="+(0,a.default)(t).data("identifier")+"]").replaceWith(t)})})}),l.on("hide.bs.modal",()=>{if(this.instances.length>0){const t=this.instances.length-1;this.instances.splice(t,1),this.currentModal=this.instances[t-1]}}),l.on("hidden.bs.modal",t=>{l.trigger("modal-destroyed"),(0,a.default)(t.currentTarget).remove(),this.instances.length>0&&(0,a.default)("body").addClass("modal-open")}),l.on("show.bs.modal",e=>{this.currentModal=(0,a.default)(e.currentTarget),this.setButtons(t.buttons),this.instances.push(this.currentModal)}),l.on("modal-dismiss",t=>{(0,a.default)(t.currentTarget).modal("hide")}),t.callback&&t.callback(l),l.modal("show"),l}}let g=null;try{parent&&parent.window.TYPO3&&parent.window.TYPO3.Modal?(parent.window.TYPO3.Modal.initializeMarkupTrigger(document),g=parent.window.TYPO3.Modal):top&&top.TYPO3.Modal&&(top.TYPO3.Modal.initializeMarkupTrigger(document),g=top.TYPO3.Modal)}catch(t){}return g||(g=new m(new i),TYPO3.Modal=g),g}));